<?php
Yii::app()->clientScript->registerScript('studentForm', '
	function showLoadingClasses()
	{
		$("#classes").prev("span").fadeIn();
		$("#classes").fadeOut();
	}

	function hideLoadingClasses()
	{
		$("#classes").prev("span").fadeOut();
		$("#classes").fadeIn();
	}

	function showLoadingCompanies()
	{
		$("#companies").prev("span").fadeIn();
		$("#companies").fadeOut();
	}

	function hideLoadingCompanies()
	{

		$("#companies").prev("span").fadeOut();
		$("#companies").fadeIn();
	}

	 //pobieranie klas na podstawie szkoly, nastepnie wyswietlanie w selectcie i wywolywanie getCompanies
	function getClasses(schoolId, classId, companyId)
	{
		//brak id szkoly - wyswietlanie pusty select
		if(schoolId == undefined || schoolId.length==0)
		{
			hideLoadingClasses();
			getCompanies(classId, companyId)
			return;
		}

		showLoadingCompanies();
		showLoadingClasses();
		$.get("'.Yii::app()->createUrl('administration/uzytkownik/getClassesBySchool').'", { schoolId: schoolId })
		.done(function(data) {
			var classes = jQuery.parseJSON(data);
			var htmlString = "";
			for(var i=0;i<classes.length;i++)
			{
				htmlString += "<option value = \""+classes[i].id+"\"";
				if(classId != undefined && classId == classes[i].id)
					htmlString += " selected=\"selected\""
				htmlString += ">"+classes[i].nazwa+"</option>";
			}
			hideLoadingClasses();
			$("#classes").html(htmlString);
			if(classId == undefined)
				$("#classes").trigger("change");
			else
				getCompanies(classId, companyId);
		});
	}

	//pobieranie firm na podstawie klasy i stworzenie z nimi selecta
	function getCompanies(classId, companyId)
	{
		//brak klasy - pusty select
		if(classId == undefined || classId.length==0)
		{
			$("#companies").html("");
			hideLoadingCompanies()
			return;
		}
		showLoadingCompanies();
		$.get("'.Yii::app()->createUrl('administration/uzytkownik/getCompaniesByClass').'", { classId: classId })
		.done(function(data) {
			var companies = jQuery.parseJSON(data);
			var htmlString = "";
			for(var i=0;i<companies.length;i++)
			{
				htmlString += "<option value = \""+companies[i].id+"\"";
				if(classId != undefined && companyId == companies[i].id)
					htmlString += " selected=\"selected\"";
				htmlString += ">"+companies[i].nazwa+"</option>";
			}
			hideLoadingCompanies();
			$("#companies").html(htmlString);
		});
	}

	$("#schools").change(function(){
		getClasses($(this).val());
	});

	$("#classes").change(function(){
		getCompanies($(this).val());
	});

	//ustawianie danych na podstawie modelu
	var schoolId = "'.$model->schoolId.'";
	var classId = "'.$model->idKlasy.'";
	var companyId = "'.$model->idFirmy.'";

	//ustawianie wartosci na podstawie modelu
	getClasses(schoolId,classId,companyId);

', CClientScript::POS_READY);
?>
<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'uzytkownik-form',
	'enableAjaxValidation'=>false,
)); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'email'); ?>
		<?php echo $form->textField($model,'email',array('size'=>60,'maxlength'=>508)); ?>
		<?php echo $form->error($model,'email'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'haslo'); ?>
		<?php echo $form->passwordField($model,'haslo',array('size'=>60,'maxlength'=>128)); ?>
		<?php echo $form->error($model,'haslo'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pesel'); ?>
		<?php echo $form->textField($model,'pesel',array('size'=>22,'maxlength'=>22)); ?>
		<?php echo $form->error($model,'pesel'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'imie'); ?>
		<?php echo $form->textField($model,'imie',array('size'=>60,'maxlength'=>64)); ?>
		<?php echo $form->error($model,'imie'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'nazwisko'); ?>
		<?php echo $form->textField($model,'nazwisko',array('size'=>60,'maxlength'=>64)); ?>
		<?php echo $form->error($model,'nazwisko'); ?>
	</div>
	<div class="redBack">

		<span style="font-weight: bold; color:#DDDDDD;">Poniższe dane zmieniać <span style="text-decoration: underline;">najpóźniej przed</span> rozpoczęciem drugiej lekcji.
		<br/>Później należy używać jednego ze znajdujących się niżej przycisków 
		<br/>służących do inteligentnego przenoszenia uczniów.</span><br/>

		<div class="row">
			<?php echo CHtml::label('Szkoła', 'schools'); ?>
			<select name="Uzytkownik[schoolId]" id="schools" <?php echo Yii::app()->user->role == 'schoolAdmin' ? 'disabled="disabled"' : '' ?>>
				<?php foreach($schools as $school):  ?>
					<option value="<?php echo $school->id ?>" <?php echo $model->schoolId==$school->id?'selected="selected"':'' ?>><?php echo $school->nazwa ?> - <?php echo $school->miasto ?></option>
				<?php endforeach; ?>
			</select>
		</div>

		<div class="row">
			<?php echo CHtml::label('Klasa', 'classes'); ?>
			<span>
				<img class="smallLoader" src="<?php echo Yii::app()->baseUrl ?>/images/ajax-loader.gif"></img>
				Proszę czekać, wczytywanie...
			</span>
			<select name="Uzytkownik[idKlasy]" id="classes" style="display: none;">

			</select>
		</div>

		<div class="row">
			<?php echo CHtml::label('Firma', 'companies'); ?>
			<span>
				<img class="smallLoader" src="<?php echo Yii::app()->baseUrl ?>/images/ajax-loader.gif"></img>
				Proszę czekać, wczytywanie...
			</span>
			<select name="Uzytkownik[idFirmy]" id="companies" style="display: none;">

			</select>
		</div>
		<div class="row">
			<span style="font-weight: bold">PRZENOSZENIE UCZNIA</span><br/>
			<a href="<?php echo $this->createUrl('/administration/uzytkownik/changeCompany', array('id'=>$model->id)) ?>" class="buttonS bGreen">Przenieś ucznia</a> |
			<a href="<?php echo $this->createUrl('/administration/firma/create', array('userId'=>$model->id)) ?>" class="buttonS bGreen">Stwórz nową firmę dla tego ucznia</a><br/>
        		<span style="font-weight: bold;">
        		Przeniesienie ucznia do istniejącej firmy pozwoli mu dołączyć<br/>
        		do grupy jej użytkowników, natomiast stworzenie nowej firmy<br/>
        		dla ucznia będzie wymagało nadrobienia przez niego zaległości<br/>
        		od początku gry. W innym przypadku nie byłoby możliwości <br/>
        		uczciwego podzielenia stanu konta pomiędzy poprzednią a nową <br/>
        		firmą, ani też podzielenia jej punktów. Punkty zdobyte przez <br/>
        		samego ucznia w poprzedniej firmie dodadzą się do jego nowej firmy.
        		</span>

		</div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'plec'); ?>
		<?php echo $form->textField($model,'plec',array('size'=>1,'maxlength'=>1)); ?>
		<?php echo $form->error($model,'plec'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'status'); ?>
		<?php echo $form->dropdownList($model,'status',array('1'=>'Aktywny','0'=>'Nieaktywny')); ?>
		<?php echo $form->error($model,'status'); ?>
	</div>

	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Dodaj' : 'Zapisz',array('class'=>'buttonS bLightBlue')); ?>
	</div>

<?php $this->endWidget(); ?>

</div>
